#include "turbo_decryptor.h"

#include <kernel/turbo/login/lib/crypto/crypto.h>

using namespace NCrypta::NCm::NApi;

TTurboDecryptor::TTurboDecryptor(const TString& secret)
    : KeyProvider(secret)
{
}

TMaybe<TTurboDecryptor::TDecrypted> TTurboDecryptor::Decrypt(const TString& encrypted) const {
    std::string yandexuid;
    std::string domain;

    if (!NTurboLogin::DecryptYuid(&KeyProvider, encrypted, yandexuid, domain)) {
        return Nothing();
    }

    return TDecrypted { .Yandexuid = TString(yandexuid), .Domain = TString(domain) };
}
