#pragma once

#include <kernel/turbo/login/lib/crypto/key_provider.h>

#include <util/generic/maybe.h>
#include <util/generic/string.h>

namespace NCrypta::NCm::NApi {
    class TTurboDecryptor {
    public:
        struct TDecrypted {
            TString Yandexuid;
            TString Domain;
        };

        explicit TTurboDecryptor(const TString& secret);

        TMaybe<TDecrypted> Decrypt(const TString& encrypted) const;

    private:
        NTurboLogin::TKeyProvider KeyProvider;
    };
}
