#pragma once

#include <crypta/cm/services/api/lib/config/ping_config.pb.h>
#include <crypta/cm/services/api/lib/logic/common/mutation_sender.h>
#include <crypta/cm/services/api/lib/logic/common/request_processor.h>
#include <crypta/cm/services/common/db_state/db_state_loader.h>
#include <crypta/lib/native/log/log.h>
#include <crypta/lib/native/yt/dyntables/async_database/kv_database.h>

#include <library/cpp/tvmauth/client/facade.h>

namespace NCrypta::NCm::NApi {
    class TPingProcessor : public TRequestProcessor {
    public:
        TPingProcessor(
            NYtDynTables::TKvDatabase& replicaDatabase,
            const TPingConfig& pingConfig,
            const NTvmAuth::TTvmClient& tvmClient,
            const TStats::TSettings& statsSettings);
        ~TPingProcessor() override = default;

    private:
        void DoProcess(NHttp::TRequestReply& reply, const TClient& clientName) override;

        NYtDynTables::TKvDatabase& ReplicaDatabase;
        const TId PingId;
        const NTvmAuth::TTvmClient& TvmClient;
    };
}
