#include "ping_request_parser.h"

#include <crypta/lib/native/http/request_parser/request_parser.h>

#include <library/cpp/http/misc/parsed_request.h>

#include <util/string/cast.h>

using namespace NCrypta::NCm::NApi;
using namespace NCrypta::NHttp;

TRequest NPingRequestParser::Parse(const TString& query) {
    TParsedHttpLocation httpLocation(query);

    Y_ENSURE(httpLocation.Path == "/ping", "Not a /ping request: " << httpLocation.Path);

    return NPingRequestParser::Parse(TCgiParameters(httpLocation.Cgi));
}

TRequest NPingRequestParser::Parse(const TCgiParameters& cgi) {
    TRequest request;
    NRequestParser::Parse(request, cgi);
    return request;
}
