#include "touch_request_parser.h"

#include <crypta/cm/services/api/lib/logic/touch/request/proto/touch_request_body.pb.h>
#include <crypta/lib/native/http/request_parser/request_parser.h>
#include <crypta/lib/native/proto_serializer/proto_serializer.h>

#include <library/cpp/http/misc/parsed_request.h>

using namespace NCrypta::NCm;
using namespace NCrypta::NCm::NApi;
using namespace NCrypta::NHttp;

TTouchRequest NTouchRequestParser::Parse(const TString& query, const TStringBuf& body) {
    TParsedHttpLocation httpLocation(query);

    Y_ENSURE(httpLocation.Path == "/touch", "Not an /touch request: " << httpLocation.Path);

    return Parse(TCgiParameters(httpLocation.Cgi), body);
}

TTouchRequest NTouchRequestParser::Parse(const TCgiParameters& cgi, const TStringBuf& body) {
    TTouchRequest request;

    NRequestParser::Parse(request, cgi);

    TTouchRequestBody protoBody;
    NProtoSerializer::FromJson(protoBody, body);
    request.Ids.reserve(protoBody.GetItems().size());
    request.TouchTimestamps.reserve(protoBody.GetItems().size());

    for (const auto& item: protoBody.GetItems()) {
        request.Ids.emplace_back(item.GetId().GetType(), item.GetId().GetValue());
        request.TouchTimestamps.emplace_back(TInstant::Seconds(item.GetTouchTimestamp()));
    }

    return request;
}
