#pragma once

#include <crypta/cm/services/api/lib/logic/common/mutation_sender.h>
#include <crypta/cm/services/api/lib/logic/common/request_processor.h>
#include <crypta/cm/services/api/lib/logic/identify/turbo_decryptor.h>
#include <crypta/cm/services/api/lib/toucher/toucher.h>
#include <crypta/cm/services/common/db_state/db_state_loader.h>
#include <crypta/cm/services/common/data/match.h>
#include <crypta/lib/native/log/log.h>
#include <crypta/lib/native/yt/dyntables/async_database/kv_database.h>

#include <util/generic/vector.h>

namespace NCrypta::NCm::NApi {
    class TTouchProcessor : public TRequestProcessor {
    public:
        TTouchProcessor(
            NYtDynTables::TKvDatabase& replicaDatabase,
            TMutationSender& mutationSender,
            const TStats::TSettings& statsSettings,
            const TToucher& toucher
        );
        ~TTouchProcessor() override = default;

    private:
        void DoProcess(NHttp::TRequestReply& reply, const TClient& clientInfo) override;

        NYtDynTables::TKvDatabase& ReplicaDatabase;
        TMutationSender& MutationSender;
        const TToucher& Toucher;
    };
}
