#pragma once

#include <contrib/libs/re2/re2/re2.h>

#include <util/generic/string.h>
#include <util/string/join.h>

namespace NCrypta::NCm::NApi {
    class TLogOnlyTypes {
    public:
        template <typename TContainer>
        TLogOnlyTypes(const TContainer& logOnlyTypes)
            : Regex("^(" + JoinSeq("|", logOnlyTypes) + ")$")
        {
            Y_ENSURE(Regex.ok(), "Failed to create log only types regex: " << Regex.error());
        }

        bool IsLogOnly(const TString& type) const;

    private:
        const re2::RE2 Regex;
    };
}
