#include "upload_request_parser.h"

#include <crypta/lib/native/http/request_parser/request_parser.h>
#include <crypta/cm/services/common/data/id_validator.h>
#include <crypta/cm/services/common/serializers/match/json/match_json_serializer.h>

#include <library/cpp/http/misc/parsed_request.h>
#include <util/string/cast.h>

using namespace NCrypta::NCm;
using namespace NCrypta::NCm::NApi;
using namespace NCrypta::NHttp;

bool NUploadRequestParser::IsUploadRequestPath(const TStringBuf& path) {
    return path == UPLOAD_PATH;
}

TUploadRequest NUploadRequestParser::Parse(const TString& query, const TStringBuf& body) {
    TParsedHttpLocation httpLocation(query);

    Y_ENSURE(IsUploadRequestPath(httpLocation.Path), "Not " << UPLOAD_PATH << " request: " << httpLocation.Path);

    return Parse(TCgiParameters(httpLocation.Cgi), body);
}

TUploadRequest NUploadRequestParser::Parse(const TCgiParameters& cgi, const TStringBuf& body) {
    TUploadRequest request;

    NRequestParser::Parse(request, cgi);

    request.Match = NMatchSerializer::FromJson(body);
    request.Match.SetMatchTs(TInstant::Zero());
    request.Match.SetCas(0);

    return request;
}
