#include "upload_request_validator.h"

#include <crypta/cm/services/common/data/id_utils.h>

#include <util/generic/hash.h>
#include <util/generic/hash_set.h>
#include <util/generic/string.h>

using namespace NCrypta::NCm::NApi;

void NUploadRequestValidator::Validate(const TUploadRequest& request) {
    Y_ENSURE(!request.Match.GetExtId().Empty(), "Ext id must not be empty");

    for (const auto& [type, matchedId] : request.Match.GetInternalIds()) {
        ValidateAttributes(matchedId.GetAttributes());
    }
}

void NUploadRequestValidator::ValidateAttributes(const TAttributes& attributes) {
    for (const auto& [attr, value] : attributes) {
        if (attr == SYNT_ATTRIBUTE) {
            Y_ENSURE(value == SYNT_TRUE_STR || value == SYNT_FALSE_STR, "Invalid value '" << value << "' for attribute '" << attr << "'");
        } else if (attr == REALTIME_ATTRIBUTE) {
            Y_ENSURE(value == REALTIME_TRUE_STR || value == REALTIME_FALSE_STR, "Invalid value '" << value << "' for attribute '" << attr << "'");
        } else {
            throw yexception() << "Invalid attribute '" << attr << "'";
        }
    }

}
