#pragma once

#include <crypta/cm/services/api/lib/logic/common/mutation_sender.h>
#include <crypta/cm/services/api/lib/logic/common/request_processor.h>
#include <crypta/cm/services/api/lib/logic/upload/log_only_types.h>
#include <crypta/cm/services/api/lib/logic/upload/request/upload_request.h>
#include <crypta/cm/services/api/lib/quoter_client/quoter_client.h>
#include <crypta/cm/services/api/lib/toucher/toucher.h>
#include <crypta/cm/services/common/data/back_reference.h>
#include <crypta/cm/services/common/data/matched_id.h>
#include <crypta/cm/services/common/db_state/db_state_loader.h>
#include <crypta/lib/native/log/log.h>
#include <crypta/lib/native/yt/dyntables/async_database/kv_database.h>

#include <utility>

namespace NCrypta::NCm::NApi {
    class TUploadProcessor: public TRequestProcessor {
    public:
        TUploadProcessor(
            TMutationSender& mutationSender,
            const TStats::TSettings& statsSettings,
            const TLogOnlyTypes& logOnlyTypes,
            const TToucher& toucher,
            TQuoterClient& quoterClient);
        ~TUploadProcessor() override = default;

    private:
        void DoProcess(NHttp::TRequestReply& reply, const TClient& clientInfo) override;

        TMutationSender& MutationSender;
        const TLogOnlyTypes& LogOnlyTypes;
        const TToucher& Toucher;
        TQuoterClient& QuoterClient;
    };
}
