#pragma once

#include <crypta/cm/services/api/lib/config/quoter_config.pb.h>
#include <crypta/cm/services/quoter/grpc/quoter_service.pb.h>
#include <crypta/lib/native/log/log.h>
#include <crypta/lib/native/periodic_task/periodic_task.h>
#include <crypta/lib/native/stats/stats.h>

#include <library/cpp/threading/light_rw_lock/lightrwlock.h>

namespace NCrypta::NCm {
    class TQuoterClient {
    public:
        TQuoterClient(const TQuoterConfig& config, const TStats::TSettings& statsSettings);

        NQuoter::TQuotaState GetQuotaState();

    private:
        void UpdateState();

        NLog::TLogPtr Log;
        TStats& Stats;

        const TString HostPort;
        const TString EnvironmentType;
        const ui64 TimeoutSec;

        TPeriodicTask CacheUpdater;

        TLightRWLock CacheLock;
        NQuoter::TQuotaState CachedState;
    };
}
