#include "request_processor_factory.h"

#include <crypta/cm/services/api/lib/logic/delete/delete_processor.h>
#include <crypta/cm/services/api/lib/logic/expire/expire_processor.h>
#include <crypta/cm/services/api/lib/logic/identify/identify_processor.h>
#include <crypta/cm/services/api/lib/logic/ping/ping_processor.h>
#include <crypta/cm/services/api/lib/logic/touch/touch_processor.h>
#include <crypta/cm/services/api/lib/logic/upload/upload_processor.h>
#include <crypta/cm/services/api/lib/logic/version/version_processor.h>

#include <library/cpp/http/misc/parsed_request.h>


using namespace NCrypta::NCm::NApi;

TProcessorFactory::TProcessorFactory(
        NYtDynTables::TKvDatabase& replicaDatabase,
        TMutationSender& mutationSender,
        const TStats::TSettings& statsSettings,
        const TLogOnlyTypes& logOnlyTypes,
        const TPingConfig& pingConfig,
        const TDuration touchTimeout,
        TQuoterClient& quoterClient,
        const TTurboDecryptor& turboDecryptor,
        const NTvmAuth::TTvmClient& tvmClient)
    : ReplicaDatabase(replicaDatabase)
    , MutationSender(mutationSender)
    , StatsSettings(statsSettings)
    , LogOnlyTypes(logOnlyTypes)
    , PingConfig(pingConfig)
    , Toucher(touchTimeout)
    , QuoterClient(quoterClient)
    , TurboDecryptor(turboDecryptor)
    , TvmClient(tvmClient)
{
}

IRequestProcessor* TProcessorFactory::GetProcessor(const TStringBuf& method, const TStringBuf& service, const TClient& client) {
    static TIdentifyProcessor identifyProcessor(ReplicaDatabase, StatsSettings, TurboDecryptor);
    static TUploadProcessor uploadProcessor(MutationSender, StatsSettings, LogOnlyTypes, Toucher, QuoterClient);
    static TDeleteProcessor deleteProcessor(ReplicaDatabase, MutationSender, StatsSettings);
    static TExpireProcessor expireProcessor(ReplicaDatabase, MutationSender, StatsSettings);
    static TVersionProcessor versionProcessor(StatsSettings);
    static TPingProcessor pingProcessor(ReplicaDatabase, PingConfig, TvmClient, StatsSettings);
    static TTouchProcessor touchProcessor(ReplicaDatabase, MutationSender, StatsSettings, Toucher);

    if (method == "GET" && service == "identify") {
        if (!client.GetPermissions().GetIdentifyAllowed()) {
            ythrow TNotAllowedException();
        }

        return &identifyProcessor;
    } else if (method == "POST" && service == "upload") {
        if (!client.GetPermissions().GetUploadAllowed()) {
            ythrow TNotAllowedException();
        }

        return &uploadProcessor;
    } else if (method == "GET" && service == "expire") {
        if (!client.GetPermissions().GetExpireAllowed()) {
            ythrow TNotAllowedException();
        }

        return &expireProcessor;
    } else if (method == "GET" && service == "delete") {
        if (!client.GetPermissions().GetDeleteAllowed()) {
            ythrow TNotAllowedException();
        }

        return &deleteProcessor;
    } else if (method == "GET" && service == "version") {
        if (!client.GetPermissions().GetVersionAllowed()) {
            ythrow TNotAllowedException();
        }

        return &versionProcessor;
    } else if (method == "GET" && service == "ping") {
        if (!client.GetPermissions().GetPingAllowed()) {
            ythrow TNotAllowedException();
        }

        return &pingProcessor;
    } else if (method == "POST" && service == "touch") {
        if (!client.GetPermissions().GetTouchAllowed()) {
            ythrow TNotAllowedException();
        }

        return &touchProcessor;
    }

    return nullptr;
}
