#pragma once

#include <crypta/cm/services/api/lib/config/clients/clients_config.pb.h>
#include <crypta/cm/services/api/lib/config/ping_config.pb.h>
#include <crypta/cm/services/api/lib/logic/common/mutation_sender.h>
#include <crypta/cm/services/api/lib/logic/common/request_processor.h>
#include <crypta/cm/services/api/lib/logic/identify/turbo_decryptor.h>
#include <crypta/cm/services/api/lib/logic/upload/log_only_types.h>
#include <crypta/cm/services/api/lib/quoter_client/quoter_client.h>
#include <crypta/cm/services/api/lib/toucher/toucher.h>
#include <crypta/lib/native/stats/stats.h>
#include <crypta/lib/native/yt/dyntables/async_database/kv_database.h>

#include <library/cpp/http/misc/parsed_request.h>

namespace NCrypta::NCm::NApi {
    class TProcessorFactory {
    public:
        class TNotAllowedException : public yexception {
        };

        TProcessorFactory(
                NYtDynTables::TKvDatabase& replicaDatabase,
                TMutationSender& mutationSender,
                const TStats::TSettings& statsSettings,
                const TLogOnlyTypes& logOnlyTypes,
                const TPingConfig& pingConfig,
                const TDuration touchTimeout,
                TQuoterClient& quoterClient,
                const TTurboDecryptor& turboDecryptor,
                const NTvmAuth::TTvmClient& tvmClient);

        IRequestProcessor* GetProcessor(const TStringBuf& method, const TStringBuf& service, const TClient& client);

    private:
        NYtDynTables::TKvDatabase& ReplicaDatabase;
        TMutationSender& MutationSender;
        const TStats::TSettings& StatsSettings;
        const TLogOnlyTypes& LogOnlyTypes;
        const TPingConfig& PingConfig;
        const TToucher Toucher;
        TQuoterClient& QuoterClient;
        const TTurboDecryptor& TurboDecryptor;
        const NTvmAuth::TTvmClient& TvmClient;
    };
}
