#pragma once

#include "request_processor_factory.h"

#include <crypta/cm/services/api/lib/config/clients/clients_config.pb.h>
#include <crypta/cm/services/api/lib/config/ping_config.pb.h>
#include <crypta/cm/services/api/lib/logic/common/mutation_sender.h>
#include <crypta/cm/services/api/lib/logic/identify/turbo_decryptor.h>
#include <crypta/cm/services/api/lib/logic/upload/log_only_types.h>
#include <crypta/cm/services/api/lib/quoter_client/quoter_client.h>
#include <crypta/lib/native/http/request_reply.h>
#include <crypta/lib/native/log/log.h>
#include <crypta/lib/native/stats/stats.h>
#include <crypta/lib/native/yt/dyntables/async_database/kv_database.h>

namespace NCrypta::NCm::NApi {
    class TWorker {
    public:
        TWorker(
                NYtDynTables::TKvDatabase& replicaDatabase,
                TMutationSender& mutationSender,
                const TStats::TSettings& statsSettings,
                const TLogOnlyTypes& logOnlyTypes,
                const TPingConfig& pingConfig,
                const TClientsConfig& clientsConfig,
                const TDuration touchTimeout,
                TQuoterClient& quoterClient,
                const TTurboDecryptor& turboDecryptor,
                const NTvmAuth::TTvmClient& tvmClient);

        void ProcessRequest(NHttp::TRequestReply& reply);

    private:
        void ReplyError(NHttp::TRequestReply& reply, HttpCodes httpCode, const TString& message);

        const TClient& GetClientInfo(const TMaybe<NTvmAuth::TCheckedServiceTicket>& clientTvmId);

        TProcessorFactory RequestProcessorFactory;
        const TClientsConfig& ClientsConfig;
        TStats& Stats;
        NLog::TLogPtr Log;
    };
}
