#pragma once

#include <crypta/cm/services/calc_expire/lib/options.pb.h>
#include <crypta/lib/native/log/log.h>

#include <mapreduce/yt/interface/fwd.h>
#include <util/generic/string.h>

#include <utility>

namespace NCrypta::NCm::NCalcExpire {
    class TCalcExpireJob {
    public:
        using TConfig = TCalcExpireJobOptions;
        explicit TCalcExpireJob(const TConfig& config, NLog::TLogPtr log);

        int Do();

    private:
        std::pair<NYT::TYPath, NYT::TYPath> FilterRowsToExpire(NYT::IClientPtr tx);

        const TConfig Config;
        NLog::TLogPtr Log;
    };
}
