#pragma once

#include <crypta/lib/native/yt/utils/tables_indexes.h>

#include <mapreduce/yt/interface/client.h>

#include <util/datetime/base.h>

namespace NCrypta::NCm::NCalcExpire {
    namespace NCalcExpireMapper {
        enum class EOutputTables {
            ToExpire,
            Errors
        };

        using TOutputIndexes = TTablesIndexes<EOutputTables>;
    }

    class TCalcExpireMapper : public NYT::IMapper<NYT::TNodeReader, NYT::TNodeWriter> {
    public:
        TCalcExpireMapper() = default;
        explicit TCalcExpireMapper(const NCalcExpireMapper::TOutputIndexes& outputIndexes, TInstant startTs);
        void Do(TReader* reader, TWriter* writer) override;

        static NCalcExpireMapper::TOutputIndexes::TBuilder PrepareOutput(const TString& dst, const TString& errors);

        Y_SAVELOAD_JOB(OutputIndexes, StartTs);

    private:
        NCalcExpireMapper::TOutputIndexes OutputIndexes;
        TInstant StartTs;
    };
}
