from util.generic.string cimport TString

from yt import yson


cdef extern from "mapreduce/yt/interface/common.h" namespace "NYT":
    cdef cppclass TNode:
        pass

    cdef cppclass TTableSchema:
        TNode ToNode() const;

cdef extern from "library/cpp/yson/public.h" namespace "NYson::EYsonFormat":
    cdef enum EYsonFormat "NYson::EYsonFormat":
        Text

cdef extern from "library/cpp/yson/node/node_io.h" namespace "NYT":
    cdef TString NodeToYsonString(const TNode& node, EYsonFormat format);


cdef extern from "crypta/cm/services/calc_expire/lib/schemas.h" namespace 'NCrypta::NCm::NCalcExpire':
    cdef TTableSchema CalcExpireSchema();
    cdef TTableSchema CalcExpireErrorsSchema();


def calc_expire_schema():
    cdef TTableSchema schema = CalcExpireSchema()
    return yson.loads(NodeToYsonString(schema.ToNode(), Text))


def calc_expire_errors_schema():
    cdef TTableSchema schema = CalcExpireErrorsSchema()
    return yson.loads(NodeToYsonString(schema.ToNode(), Text))

