#include "schemas.h"

#include "fields.h"

#include <crypta/lib/native/yt/dyntables/kv_schema/fields.h>


using namespace NCrypta::NCm;

NYT::TTableSchema NCalcExpire::CalcExpireSchema() {
    return NYT::TTableSchema()
            .AddColumn(NYT::TColumnSchema().Name(NExpirationFields::TYPE).Type(NYT::VT_STRING, /*required*/ true))
            .AddColumn(NYT::TColumnSchema().Name(NExpirationFields::VALUE).Type(NYT::VT_STRING, /*required*/ true))
            .AddColumn(NYT::TColumnSchema().Name(NExpirationFields::UNIXTIME).Type(NYT::VT_UINT64, /*required*/ true))
            .Strict(true);
}

NYT::TTableSchema NCalcExpire::CalcExpireErrorsSchema() {
    return NYT::TTableSchema()
            .AddColumn(NYT::TColumnSchema().Name(NExpirationFields::KEY).Type(NYT::VT_STRING, /*required*/ true))
            .AddColumn(NYT::TColumnSchema().Name(NExpirationFields::VALUE).Type(NYT::VT_STRING, /*required*/ false))
            .AddColumn(NYT::TColumnSchema().Name(NExpirationFields::ERROR).Type(NYT::VT_STRING, /*required*/ true))
            .AddColumn(NYT::TColumnSchema().Name(NExpirationFields::UNIXTIME).Type(NYT::VT_UINT64, /*required*/ true))
            .Strict(true);
}
