#pragma once

#include <crypta/cm/services/common/data/id.h>

#include <library/cpp/json/writer/json_value.h>

#include <util/datetime/base.h>

namespace NCrypta::NCm {
    struct TExtIdCommand {
        TExtIdCommand() = default;
        TExtIdCommand(const TString& command, const TString& shardingKey, const TId& extId, TInstant timestamp);

        bool operator==(const TExtIdCommand& other) const;
        bool operator!=(const TExtIdCommand& other) const;

        TString ToString() const;
        static TExtIdCommand FromJsonValue(const NJson::TJsonValue& v, const TString& type);

        TString Command;
        TString ShardingKey;
        TId ExtId;
        TInstant Timestamp;
    };
}
