from util.datetime.base cimport TInstant
from util.datetime.base cimport TDuration
from util.generic.string cimport TString
from util.system.types cimport ui64

from crypta.cm.services.common.changes.touch_command cimport TTouchCommand as TTouchCommandImpl
from crypta.cm.services.common.data.python.id cimport TId


cdef class TTouchCommand:
    def __init__(self, TString shardingKey, TId extId, ui64 touchTs, ui64 timestamp):
        self._cpp_impl.ShardingKey = shardingKey
        self._cpp_impl.ExtId = extId._cpp_impl
        self._cpp_impl.TouchTs = TInstant.Seconds(touchTs)
        self._cpp_impl.Timestamp = TInstant.Seconds(timestamp)

    @staticmethod
    def ToString(TTouchCommand touch_command):
        return TTouchCommandImpl.ToString(touch_command._cpp_impl)
