from libcpp cimport bool

from util.datetime.base cimport TInstant
from util.generic.string cimport TString
from util.system.types cimport ui64

from crypta.cm.services.common.data.python.match cimport TMatch
from crypta.cm.services.common.changes.upload_command cimport TUploadCommand as TUploadCommandImpl


cdef class TUploadCommand:
    def __init__(self, TString shardingKey, TMatch incomingMatch, ui64 timestamp):
        self._cpp_impl.ShardingKey = shardingKey
        self._cpp_impl.IncomingMatch = incomingMatch._cpp_impl
        self._cpp_impl.Timestamp = TInstant.Seconds(timestamp)

    def GetMatch(self):
        return TMatch.Clone(self._cpp_impl.IncomingMatch)

    @staticmethod
    def ToString(TUploadCommand upload_command):
        return TUploadCommandImpl.ToString(upload_command._cpp_impl)
