#pragma once

#include <crypta/cm/services/common/data/id.h>

#include <library/cpp/json/writer/json_value.h>

#include <util/datetime/base.h>

namespace NCrypta::NCm {
    struct TTouchCommand {
        TTouchCommand() = default;
        TTouchCommand(const TString& shardingKey, const TId& extId, TInstant touch, TInstant timestamp = TInstant::Now());

        bool operator==(const TTouchCommand& other) const;
        bool operator!=(const TTouchCommand& other) const;

        static TString ToString(const TTouchCommand& touchCommand);
        static TTouchCommand FromJsonValue(const NJson::TJsonValue& v);

        TString ShardingKey;
        TId ExtId;
        TInstant TouchTs;
        TInstant Timestamp;
    };
}
