from libcpp cimport bool

from util.datetime.base cimport TDuration
from util.datetime.base cimport TInstant
from util.generic.string cimport TString

from crypta.cm.services.common.data.id cimport TId


cdef extern from "crypta/cm/services/common/changes/touch_command.h" namespace "NCrypta::NCm" nogil:
    cdef cppclass TTouchCommand:
        TString ShardingKey
        TId ExtId
        TInstant TouchTs
        TDuration Ttl
        TInstant Timestamp

        TTouchCommand() except +
        TTouchCommand(const TString& shardingKey, const TId& extId, TInstant touch, TDuration ttl, TInstant timestamp) except +

        TTouchCommand(const TTouchCommand&) except +

        bool operator==(const TTouchCommand& other) const
        bool operator!=(const TTouchCommand& other) const

        @staticmethod
        TString ToString(const TTouchCommand& touchCommand)
