#pragma once

#include <crypta/cm/services/common/data/match.h>

#include <library/cpp/json/writer/json_value.h>

namespace NCrypta::NCm {
    struct TUploadCommand {
        TUploadCommand() = default;
        explicit TUploadCommand(const TString& shardingKey, const TMatch& incomingMatch, TInstant timestamp = TInstant::Now());

        bool operator==(const TUploadCommand&) const;
        bool operator!=(const TUploadCommand&) const;

        static TString ToString(const TUploadCommand& uploadCommand);
        static TUploadCommand FromJsonValue(const NJson::TJsonValue& v);

        TString ShardingKey;
        TMatch IncomingMatch;
        TInstant Timestamp;
    };
}
