from libcpp cimport bool

from util.datetime.base cimport TInstant
from util.generic.string cimport TString

from crypta.cm.services.common.data.match cimport TMatch


cdef extern from "crypta/cm/services/common/changes/upload_command.h" namespace "NCrypta::NCm" nogil:
    cdef cppclass TUploadCommand:
        TString ShardingKey
        TMatch IncomingMatch
        TInstant Timestamp

        TUploadCommand() except +
        TUploadCommand(const TString& shardingKey, const TMatch& incomingMatch) except +

        TUploadCommand(const TUploadCommand&) except +

        bool operator==(const TUploadCommand& other) const
        bool operator!=(const TUploadCommand& other) const

        @staticmethod
        TString ToString(const TUploadCommand& uploadCommand)
