#include "back_reference.h"

using namespace NCrypta::NCm;

TBackReference::TBackReference(TId id, TExtIds refs)
    : Id(std::move(id))
    , Refs(std::move(refs))
{
}

bool TBackReference::operator==(const TBackReference& other) const {
    return (Id == other.Id) && (Refs == other.Refs);
}

bool TBackReference::operator!=(const TBackReference& other) const {
    return !(*this == other);
}
