from libcpp cimport bool
from libcpp.pair cimport pair

from util.generic.hash_set cimport THashSet

from crypta.cm.services.common.data.id cimport TId

ctypedef THashSet[TId] TExtIds

cdef extern from "crypta/cm/services/common/data/back_reference.h" namespace "NCrypta::NCm" nogil:
    cdef cppclass TBackReference:
        TId Id
        TExtIds Refs

        TBackReference() except +
        TBackReference(TId id, TExtIds refs) except +

        bool operator==(const TBackReference& other) const
        bool operator!=(const TBackReference& other) const
