#include "id.h"

using namespace NCrypta::NCm;

TId::TId(const TString& type, const TString& value)
    : Type(type)
    , Value(value)
{
}

bool TId::operator==(const TId& other) const {
    return (Value == other.Value) && (Type == other.Type);
}

bool TId::operator!=(const TId& other) const {
    return !(*this == other);
}

bool TId::Empty() const {
    return Type.empty() || Value.empty();
}
