#pragma once

#include <util/generic/string.h>

namespace NCrypta::NCm {
    struct TId {
        TString Type;
        TString Value;

        TId() = default;
        TId(const TString& type, const TString& value);
        TId(const TId&) = default;
        TId(TId&&) = default;
        TId& operator=(const TId&) = default;
        TId& operator=(TId&&) = default;
        bool operator==(const TId& other) const;
        bool operator!=(const TId& other) const;

        bool Empty() const;
    };
}
