#include "id_validator.h"

#include <algorithm>

using namespace NCrypta::NCm;

namespace {
    const size_t MAX_ID_TYPE_LENGTH = 20;
    const size_t MAX_ID_VALUE_LENGTH = 200;
}

bool NIdValidator::IsValid(const TId& id) {
    return !id.Type.empty() && id.Type.size() <= MAX_ID_TYPE_LENGTH &&
           !id.Value.empty() && id.Value.size() <= MAX_ID_VALUE_LENGTH &&
           std::all_of(id.Type.begin(), id.Type.end(), [](unsigned char c) { return std::isalnum(c) || c == '_'; }) &&
           std::all_of(id.Value.begin(), id.Value.end(), [](unsigned char c) { return std::isgraph(c) || c == ' '; });
}
