#include "match.h"

#include "match_comparator.h"

#include <utility>

using namespace NCrypta::NCm;

TMatch::TMatch(TId extId, TMatchedIds ids, TInstant touch, TDuration ttl, bool trackBackReference)
    : ExtId(std::move(extId))
    , Ids(std::move(ids))
    , Touch(touch)
    , Ttl(ttl)
    , TrackBackReference(trackBackReference)
{
}

bool TMatch::operator==(const TMatch& other) const {
    return NMatchComparator::Equal(*this, other);
}

bool TMatch::operator!=(const TMatch& other) const {
    return ! operator==(other);
}

const TId& TMatch::GetExtId() const {
    return ExtId;
}

const TMatch::TMatchedIds& TMatch::GetInternalIds() const {
    return Ids;
}

TInstant TMatch::GetTouch() const {
    return Touch;
}

TDuration TMatch::GetTtl() const {
    return Ttl;
}

bool TMatch::GetTrackBackReference() const {
    return TrackBackReference;
}

void TMatch::SetExtId(const TId& id) {
    ExtId = id;
}

void TMatch::AddId(TMatchedId id) {
    Y_ENSURE(Ids.emplace(id.GetId().Type, std::move(id)).second, "Allowed only one id for each type");
}

void TMatch::SetTouch(TInstant touch) {
    Touch = touch;
}

void TMatch::SetTtl(TDuration ttl) {
    Ttl = ttl;
}

void TMatch::SetTrackBackReference(bool trackBackReference) {
    TrackBackReference = trackBackReference;
}

void TMatch::SetMatchTs(TInstant matchTs) {
    for (auto& [type, matchedId] : Ids) {
        matchedId.SetMatchTs(matchTs);
    }
}

void TMatch::SetCas(ui64 cas) {
    for (auto& [type, matchedId] : Ids) {
        matchedId.SetCas(cas);
    }
}

void TMatch::Clear() {
    ExtId = TId();
    Ids.clear();
}

TMatch::TMatchedIdPtr TMatch::FindInternalId(const TIdType& type) const {
    auto it = Ids.find(type);
    return it.IsEnd() ? nullptr : &it->second;
}

bool TMatch::Contains(const TId& id) const {
    const auto& matchedIdPtr = FindInternalId(id.Type);
    return (matchedIdPtr != nullptr) && (matchedIdPtr->GetId() == id);
}
