#pragma once

#include "id.h"
#include "attributes.h"
#include "matched_id.h"

#include <util/datetime/base.h>
#include <util/generic/vector.h>

namespace NCrypta::NCm {
    class TMatch {
    public:
        using TIdType = TString;
        using TMatchedIds = THashMap<TIdType, TMatchedId>;
        using TMatchedIdPtr = const TMatchedId*;

        TMatch() = default;
        TMatch(TId extId,
               TMatchedIds ids = {},
               TInstant touch = TInstant::Zero(),
               TDuration ttl = TDuration::Zero(),
               bool trackBackReference = false);
        TMatch(const TMatch&) = default;
        TMatch(TMatch&&) = default;
        virtual ~TMatch() = default;

        TMatch& operator=(const TMatch&) = default;
        TMatch& operator=(TMatch&&) = default;

        bool operator==(const TMatch& other) const;
        bool operator!=(const TMatch& other) const;

        const TId& GetExtId() const;
        const TMatchedIds& GetInternalIds() const;
        TInstant GetTouch() const;
        TDuration GetTtl() const;
        bool GetTrackBackReference() const;

        void SetExtId(const TId& id);
        void AddId(TMatchedId id);
        void SetTouch(TInstant touch);
        void SetTtl(TDuration ttl);
        void SetMatchTs(TInstant matchTs);
        void SetCas(ui64 cas);
        void SetTrackBackReference(bool trackBackReference);

        void Clear();

        TMatchedIdPtr FindInternalId(const TIdType& type) const;
        bool Contains(const TId& id) const;

    private:
        TId ExtId;
        TMatchedIds Ids;
        TInstant Touch;
        TDuration Ttl;
        bool TrackBackReference = false;
    };
}
