from libcpp cimport bool

from util.generic.string cimport TString
from util.generic.hash cimport THashMap
from util.datetime.base cimport (
    TInstant,
    TDuration,
)

from crypta.cm.services.common.data.attributes cimport TAttributes
from crypta.cm.services.common.data.id cimport TId
from crypta.cm.services.common.data.matched_id cimport TMatchedId

ctypedef THashMap[TString, TMatchedId] TMatchedIds

cdef extern from "crypta/cm/services/common/data/match.h" namespace "NCrypta::NCm" nogil:
    cdef cppclass TMatch:
        TMatch() except +
        TMatch(const TId& id, const TMatchedIds& matchedIds, TInstant touch, TDuration ttl) except +

        const TId& GetExtId() const
        void SetExtId(const TId&)
        
        const TMatchedIds& GetInternalIds() const
        void AddId(const TMatchedId& id)

        TInstant GetTouch() const
        void SetTouch(TInstant touch)

        TDuration GetTtl() const
        void SetTtl(TDuration ttl)

        bool operator==(const TMatch& other) const
        bool operator!=(const TMatch& other) const
