#include "match_comparator.h"

using namespace NCrypta::NCm;

bool NMatchComparator::Equal(const TMatch& first, const TMatch& second, EModeFlags mode, NMatchedIdComparator::EModeFlags internalIdMode) {
    if (mode.HasFlags(EMode::ExtId) && (first.GetExtId() != second.GetExtId())) {
        return false;
    }

    if (mode.HasFlags(EMode::Touch) && (first.GetTouch() != second.GetTouch())) {
        return false;
    }

    if (mode.HasFlags(EMode::Ttl) && (first.GetTtl() != second.GetTtl())) {
        return false;
    }

    if (mode.HasFlags(EMode::TrackBackReference) && (first.GetTrackBackReference() != second.GetTrackBackReference())) {
        return false;
    }

    if (!mode.HasFlags(EMode::InternalIds)) {
        return true;
    }

    const auto& firstInternalIds = first.GetInternalIds();
    const auto& secondInternalIds = second.GetInternalIds();

    if (firstInternalIds.size() != secondInternalIds.size()) {
        return false;
    }

    for (const auto& [type, firstInternalId] : firstInternalIds) {
        const auto it = secondInternalIds.find(type);

        if (it == secondInternalIds.end()) {
            return false;
        }

        const auto& secondInternalId = it->second;

        if (!NMatchedIdComparator::Equal(firstInternalId, secondInternalId, internalIdMode)) {
            return false;
        }
    }

    return true;
}
