#pragma once

#include "match.h"
#include "matched_id_comparator.h"

#include <util/generic/flags.h>

namespace NCrypta::NCm::NMatchComparator {
    enum class EMode {
        ExtId = 1 << 0,
        Touch = 1 << 1,
        Ttl = 1 << 2,
        InternalIds = 1 << 3,
        TrackBackReference = 1 << 4,
        All = ExtId | Touch | Ttl | InternalIds | TrackBackReference
    };

    Y_DECLARE_FLAGS(EModeFlags, EMode);
    Y_DECLARE_OPERATORS_FOR_FLAGS(EModeFlags);

    bool Equal(const TMatch& first, const TMatch& second, EModeFlags mode = EMode::All, NMatchedIdComparator::EModeFlags internalIdMode = NMatchedIdComparator::EMode::All);
}
