#include "match_validator.h"

#include "id_validator.h"

#include <util/generic/algorithm.h>

using namespace NCrypta::NCm;

bool NMatchValidator::IsValid(const TMatch& match) {
    if (!NIdValidator::IsValid(match.GetExtId()) || match.GetInternalIds().size() == 0) {
        return false;
    }

    return AllOf(match.GetInternalIds().begin(), match.GetInternalIds().end(),
                 [](const auto& pair) { return NIdValidator::IsValid(pair.second.GetId()); });
}
