#include "matched_id.h"

#include "id_utils.h"
#include "matched_id_comparator.h"

#include <utility>

using namespace NCrypta::NCm;


TMatchedId::TMatchedId(TId id,
                       TInstant matchTs,
                       ui64 cas,
                       TAttributes attributes)
    : Id(std::move(id))
    , MatchTs(matchTs)
    , Cas(cas)
    , Attributes(std::move(attributes))
{
}

bool TMatchedId::operator==(const TMatchedId& other) const {
    return NMatchedIdComparator::Equal(*this, other);
}

bool TMatchedId::operator!=(const TMatchedId& other) const {
    return ! operator==(other);
}

void TMatchedId::Clear() {
    Id = TId();
    MatchTs = TInstant::Zero();
    Cas = 0u;
    Attributes.clear();
}

const TId& TMatchedId::GetId() const {
    return Id;
}

TInstant TMatchedId::GetMatchTs() const {
    return MatchTs;
}

ui64 TMatchedId::GetCas() const {
    return Cas;
}

const TAttributes& TMatchedId::GetAttributes() const {
    return Attributes;
}

void TMatchedId::SetId(const TId& id) {
    Id = id;
}

void TMatchedId::SetMatchTs(TInstant matchTs) {
    MatchTs = matchTs;
}

void TMatchedId::SetCas(ui64 cas) {
    Cas = cas;
}

void TMatchedId::SetAttributes(TAttributes attributes) {
    Attributes = std::move(attributes);
}

bool TMatchedId::IsRealtime() const {
    auto it = Attributes.find(REALTIME_ATTRIBUTE);
    if (it != Attributes.end()) {
        return it->second == REALTIME_TRUE_STR;
    }
    return false;
}