#pragma once

#include "attributes.h"
#include "id.h"

#include <util/datetime/base.h>
#include <util/generic/string.h>

namespace NCrypta::NCm {
    class TMatchedId {
    public:
        TMatchedId() = default;
        explicit TMatchedId(TId id,
                            TInstant matchTs = TInstant::Zero(),
                            ui64 cas = 0,
                            TAttributes attributes = TAttributes());
        TMatchedId(const TMatchedId&) = default;
        TMatchedId(TMatchedId&&) = default;
        TMatchedId& operator=(const TMatchedId&) = default;
        TMatchedId& operator=(TMatchedId&&) = default;

        bool operator==(const TMatchedId& other) const;
        bool operator!=(const TMatchedId& other) const;

        void Clear();

        const TId& GetId() const;
        TInstant GetMatchTs() const;
        ui64 GetCas() const;
        const TAttributes& GetAttributes() const;

        void SetId(const TId& id);
        void SetMatchTs(TInstant matchTs);
        void SetCas(ui64 cas);
        void SetAttributes(TAttributes attributes);

        bool IsRealtime() const;

    private:
        TId Id;
        TInstant MatchTs;
        ui64 Cas = 0;
        TAttributes Attributes;
    };

    using TMatchedIds = TVector<TMatchedId>;
}
