from libcpp cimport bool

from util.datetime.base cimport TInstant
from util.generic.string cimport TString
from util.system.types cimport ui64

from crypta.cm.services.common.data.attributes cimport TAttributes
from crypta.cm.services.common.data.id cimport TId

cdef extern from "crypta/cm/services/common/data/matched_id.h" namespace "NCrypta::NCm" nogil:
    cdef cppclass TMatchedId:
        TMatchedId() except +
        TMatchedId(TId id, TInstant matchTs, ui64 cas, const TAttributes& attributes) except +

        TMatchedId& operator=(const TMatchedId&)
        TMatchedId& operator=(TMatchedId&&)

        bool operator==(const TMatchedId& other) const
        bool operator!=(const TMatchedId& other) const

        const TId& GetId() const
        TInstant GetMatchTs() const
        ui64 GetCas() const
        const TAttributes& GetAttributes() const

        void SetAttributes(TAttributes attributes);
