#include "matched_id_comparator.h"

using namespace NCrypta::NCm;

bool NMatchedIdComparator::Equal(const TMatchedId& first, const TMatchedId& second, EModeFlags mode) {
    if (mode.HasFlags(EMode::Id) && (first.GetId() != second.GetId())) {
        return false;
    }

    if (mode.HasFlags(EMode::Attributes) && (first.GetAttributes() != second.GetAttributes())) {
        return false;
    }

    if (mode.HasFlags(EMode::MatchTs) && (first.GetMatchTs() != second.GetMatchTs())) {
        return false;
    }

    if (mode.HasFlags(EMode::Cas) && (first.GetCas() != second.GetCas())) {
        return false;
    }

    return true;
}
