#pragma once

#include "match.h"

#include <util/generic/flags.h>

namespace NCrypta::NCm::NMatchedIdComparator {
    enum class EMode {
        Id = 1 << 0,
        Attributes = 1 << 1,
        MatchTs = 1 << 2,
        Cas = 1 << 3,
        All = Id | Attributes | MatchTs | Cas
    };

    Y_DECLARE_FLAGS(EModeFlags, EMode);
    Y_DECLARE_OPERATORS_FOR_FLAGS(EModeFlags);

    bool Equal(const TMatchedId& first, const TMatchedId& second, EModeFlags mode = EMode::All);
}
