#include "proto_helpers.h"

#include "match.h"

#include <util/generic/xrange.h>

#include <algorithm>

using namespace NCrypta::NCm;

TIdProto NCrypta::NCm::MakeIdProto(const TString& type, const TString& value) {
    TIdProto proto;
    proto.SetType(type);
    proto.SetValue(value);
    return proto;
}

TIdProto NCrypta::NCm::MakeIdProto(const TId& id) {
    return MakeIdProto(id.Type, id.Value);
}

TId NCrypta::NCm::MakeId(const TIdProto& proto) {
    return TId(proto.GetType(), proto.GetValue());
}

TBackRefProto NCrypta::NCm::MakeBackRef(const TIdProto& id, const TIdProto& extId) {
    TBackRefProto ret;
    *ret.MutableId() = id;
    *ret.AddRefs() = extId;
    return ret;
}

void NCrypta::NCm::SerializeAttributes(const TAttributes& attributes, TAttributesProto& proto) {
    for (const auto& kvp : attributes) {
        auto attr = proto.Add();
        attr->set_name(kvp.first);
        attr->set_value(kvp.second);
    }
}

TAttributes NCrypta::NCm::DeserializeAttributes(const TAttributesProto& proto) {
    TAttributes attributes;
    for (const auto& attr : proto) {
        attributes[attr.name()] = attr.value();
    }
    return attributes;
}

bool crypta::cm::proto::operator==(const TMatchProto& left, const TMatchProto& right) {
    if ((left.GetExtId() != right.GetExtId()) || (left.GetMatchedIds().IdsSize() != right.GetMatchedIds().IdsSize())) {
        return false;
    }

    return std::equal(left.GetMatchedIds().GetIds().begin(), left.GetMatchedIds().GetIds().end(), right.GetMatchedIds().GetIds().begin());
}

bool crypta::cm::proto::operator!=(const TMatchProto& left, const TMatchProto& right) {
    return !(left == right);
}

bool crypta::cm::proto::operator==(const TMatchedIdProto& left, const TMatchedIdProto& right) {
    if ((left.GetId() != right.GetId()) ||
        (left.GetMatchTs() != right.GetMatchTs()) ||
        (left.GetCas() != right.GetCas()) ||
        (left.AttributesSize() != right.AttributesSize()))
    {
        return false;
    }

    return std::equal(left.GetAttributes().begin(), left.GetAttributes().end(), right.GetAttributes().begin());
}

bool crypta::cm::proto::operator!=(const TMatchedIdProto& left, const TMatchedIdProto& right) {
    return !(left == right);
}

bool crypta::cm::proto::operator==(const TAttributeProto& left, const TAttributeProto& right) {
    return (left.GetName() == right.GetName()) && (left.GetValue() == right.GetValue());
}

bool crypta::cm::proto::operator!=(const TAttributeProto& left, const TAttributeProto& right) {
    return !(left == right);
}

bool crypta::cm::proto::operator==(const TBackRefProto& left, const TBackRefProto& right) {
    if ((left.GetId() != right.GetId()) || (left.RefsSize() != right.RefsSize())) {
        return false;
    }

    return std::equal(left.GetRefs().begin(), left.GetRefs().end(), right.GetRefs().begin());
}

bool crypta::cm::proto::operator!=(const TBackRefProto& left, const TBackRefProto& right) {
    return !(left == right);
}
