#pragma once

#include <crypta/cm/services/common/data/attributes.h>
#include <crypta/cm/services/common/data/id.h>
#include <crypta/cm/services/common/proto/match.pb.h>
#include <crypta/lib/proto/identifiers/native/id.h>

namespace NCrypta::NCm {
    using TIdProto = NCrypta::TId;
    using TMatchedIdProto = crypta::cm::proto::TMatchedId;
    using TMatchedIdsProto = ::google::protobuf::RepeatedPtrField<crypta::cm::proto::TMatchedId>;
    using TAttributeProto = crypta::cm::proto::TAttribute;
    using TAttributesProto = google::protobuf::RepeatedPtrField<crypta::cm::proto::TAttribute>;
    using TBackRefProto = crypta::cm::proto::TBackReference;
    using TMatchProto = crypta::cm::proto::TMatch;

    TIdProto MakeIdProto(const TString& type, const TString& value);
    TIdProto MakeIdProto(const TId& id);
    TId MakeId(const TIdProto& proto);
    TBackRefProto MakeBackRef(const TIdProto& id, const TIdProto& extId);

    void SerializeAttributes(const TAttributes& attributes, TAttributesProto& proto);
    TAttributes DeserializeAttributes(const TAttributesProto& proto);
}

namespace NCrypta {
    using namespace NCrypta::NCm;

    bool operator==(const TIdProto& left, const TIdProto& right);
    bool operator!=(const TIdProto& left, const TIdProto& right);
}

namespace crypta::cm::proto {
    using namespace NCrypta::NCm;

    bool operator==(const TMatchedIdProto& left, const TMatchedIdProto& right);
    bool operator!=(const TMatchedIdProto& left, const TMatchedIdProto& right);
    bool operator==(const TAttributeProto& left, const TAttributeProto& right);
    bool operator!=(const TAttributeProto& left, const TAttributeProto& right);
    bool operator==(const TBackRefProto& left, const TBackRefProto& right);
    bool operator!=(const TBackRefProto& left, const TBackRefProto& right);
    bool operator==(const TMatchProto& left, const TMatchProto& right);
    bool operator!=(const TMatchProto& left, const TMatchProto& right);
}
