from crypta.cm.services.common.data.back_reference cimport TBackReference as TBackReferenceImpl
from crypta.cm.services.common.data.python.id cimport TId

cdef class TBackReference:
    def __init__(self, TId id, ext_id_refs):
        self._cpp_impl.Id = id._cpp_impl
        for ext_id in ext_id_refs:
            self._add_id(ext_id)

    def GetId(self):
        return TId.Clone(self._cpp_impl.Id)

    def GetRefs(self):
        ret = set()

        for ref_impl in self._cpp_impl.Refs:
            ret.add(TId.Clone(ref_impl))

        return ret

    def _add_id(self, TId id):
        self._cpp_impl.Refs.insert(id._cpp_impl)

    def __eq__(self, TBackReference other):
        return self._cpp_impl == other._cpp_impl

    def __ne__(self, TBackReference other):
        return not self.__eq__(other)
