import six

from util.generic.string cimport TString

from crypta.cm.services.common.data.id cimport TId as TIdImpl


cdef class TId:
    def __init__(self, type, value):
        self._cpp_impl.Type = six.ensure_binary(type)
        self._cpp_impl.Value = six.ensure_binary(value)

    @property
    def Type(self):
        return six.ensure_str(self._cpp_impl.Type)

    @Type.setter
    def Type(self, value):
        self._cpp_impl.Type = six.ensure_binary(value)

    @property
    def Value(self):
        return six.ensure_str(self._cpp_impl.Value)

    @Value.setter
    def Value(self, value):
        self._cpp_impl.Value = six.ensure_binary(value)

    def __repr__(self):
        return "TId('{type}', '{value}')".format(type=self.Type, value=self.Value)

    def __eq__(self, TId other):
        return self._cpp_impl == other._cpp_impl

    def __ne__(self, TId other):
        return self._cpp_impl != other._cpp_impl

    def __hash__(self):
        return hash((self.Type, self.Value))
