import six

from util.generic.vector cimport TVector
from util.system.types cimport ui64

from util.datetime.base cimport (
    TInstant,
    TDuration,
)

from crypta.cm.services.common.data.match cimport TMatch as TMatchImpl
from crypta.cm.services.common.data.matched_id cimport TMatchedId as TMatchedIdImpl
from crypta.cm.services.common.data.python.id cimport TId
from crypta.cm.services.common.data.python.matched_id cimport TMatchedId


cdef class TMatch:
    def __init__(self, TId ext_id, matched_ids, ui64 touch, ui64 ttl):
        self.SetExtId(ext_id)

        for matched_id in matched_ids.values():
            self.AddId(matched_id)

        self.SetTouch(touch)
        self.SetTtl(ttl)

    def SetExtId(self, TId ext_id):
        self._cpp_impl.SetExtId(ext_id._cpp_impl)

    def AddId(self, TMatchedId matched_id):
        self._cpp_impl.AddId(matched_id._cpp_impl)

    def GetExtId(self):
        id_impl = self._cpp_impl.GetExtId()
        return TId(id_impl.Type, id_impl.Value)

    def GetInternalIds(self):
        ret = dict()
        matched_ids = self._cpp_impl.GetInternalIds()
        for pair in matched_ids:
            ret[six.ensure_str(pair.first)] = TMatchedId.Clone(pair.second)
        return ret

    def GetTouch(self):
        return self._cpp_impl.GetTouch().Seconds()

    def SetTouch(self, ui64 touch):
        return self._cpp_impl.SetTouch(TInstant.Seconds(touch))

    def GetTtl(self):
        return self._cpp_impl.GetTtl().Seconds()

    def SetTtl(self, ui64 ttl):
        return self._cpp_impl.SetTtl(TDuration.Seconds(ttl))

    def __repr__(self):
        return "TMatch(ext_id={ext_id}, matched_ids={matched_ids}, touch={touch}, ttl={ttl})".format(
            ext_id=repr(self.GetExtId()),
            matched_ids=repr(self.GetInternalIds()),
            touch=self.GetTouch(),
            ttl=self.GetTtl(),
        )

    def __eq__(self, TMatch other):
        return self._cpp_impl == other._cpp_impl

    def __ne__(self, TMatch other):
        return not self.__eq__(other)
