import six

from util.system.types cimport ui64

from util.datetime.base cimport TInstant
from util.generic.string cimport TString

from crypta.cm.services.common.data.attributes cimport TAttributes
from crypta.cm.services.common.data.id cimport TId as TIdImpl
from crypta.cm.services.common.data.matched_id cimport TMatchedId as TMatchedIdImpl
from crypta.cm.services.common.data.python import common
from crypta.cm.services.common.data.python.id cimport TId


cdef class TMatchedId:
    def __init__(self, TId id, ui64 match_ts = 0, ui64 cas = 0, attributes = None):
        if attributes is None:
            attributes = {}
        else:
            attributes = common.ensure_dict_binary(attributes)

        cdef TIdImpl id_impl = TIdImpl(six.ensure_binary(id.Type), six.ensure_binary(id.Value))
        self._cpp_impl = TMatchedIdImpl(id_impl, TInstant.Seconds(match_ts), cas, attributes)

    @property
    def Id(self):
        cdef TIdImpl id_impl = self._cpp_impl.GetId()
        return TId(id_impl.Type, id_impl.Value)

    @property
    def MatchTs(self):
        return self._cpp_impl.GetMatchTs().Seconds()

    @property
    def Cas(self):
        return self._cpp_impl.GetCas()

    @property
    def Attributes(self):
        return common.ensure_dict_str(self._cpp_impl.GetAttributes())

    @Attributes.setter
    def Attributes(self, attributes):
        self._cpp_impl.SetAttributes(common.ensure_dict_binary(attributes))

    def __repr__(self):
        return "TMatchedId(id={id}, match_ts={match_ts}, cas={cas}, attributes={attributes})".format(
            id=repr(self.Id),
            match_ts=self.MatchTs,
            cas=self.Cas,
            attributes=self.Attributes,
        )

    def __eq__(self, TMatchedId other):
        return self._cpp_impl == other._cpp_impl

    def __ne__(self, TMatchedId other):
        return not self.__eq__(other)
