#include "random_id_utils.h"

#include <crypta/cm/services/common/data/id_utils.h>

#include <util/random/random.h>
#include <util/string/cast.h>

using namespace NCrypta;
using namespace NCrypta::NCm;

namespace {
    const ui64 TS_PREFIX = 1'500'000'000;
    const ui64 TS_RANDOM_PART = 500'000'000;
    const ui64 MAX_TTL = 1'000'000;

    TInstant GetRandomTs() {
        return TInstant::Seconds(TS_PREFIX + RandomNumber<ui64>(TS_RANDOM_PART));
    }

    TDuration GetRandomTtl() {
        return TDuration::Seconds(RandomNumber<ui64>(MAX_TTL));
    }
}

TId NCm::CreateRandomId(const TString& type) {
    return TId(type, ToString(GetRandomTs().Seconds()));
}

TMatchedId NCm::CreateRandomMatchedId(const TString& type, const TAttributes& attrs) {
    return TMatchedId(CreateRandomId(type), GetRandomTs(), 0, attrs);
}

TMatch NCm::CreateRandomMatch(const TString& extIdType, const TString& yuidSynt, const TString& icookieSynt) {
    TMatch result(CreateRandomId(extIdType), {}, GetRandomTs(), GetRandomTtl());

    if (!yuidSynt.empty()) {
        result.AddId(CreateRandomMatchedId(YANDEXUID_TYPE, {{SYNT_ATTRIBUTE, yuidSynt}}));
    }

    if (!icookieSynt.empty()) {
        result.AddId(CreateRandomMatchedId(ICOOKIE_TYPE, {{SYNT_ATTRIBUTE, icookieSynt}}));
    }

    return result;
}
