#pragma once

#include "change_tracking_map.h"

#include <crypta/cm/services/common/data/back_reference.h>
#include <crypta/cm/services/common/data/id_hash.h>
#include <crypta/cm/services/common/data/match.h>

#include <util/generic/hash.h>
#include <util/generic/vector.h>

namespace NCrypta::NCm {
    struct TDbState {
    public:
        using TMatchMap = TChangeTrackingMap<TMatch>;
        using TBackRefMap = TChangeTrackingMap<TBackReference>;

        TDbState(TMatchMap::TMap matchesMap, TBackRefMap::TMap backRefsMap, const THashSet<TString>& trackedBackRefTags);

        void WriteMatch(const TMatch& incomingMatch);
        void DeleteMatch(const TId& extId);
        void TouchMatch(const TId& extId, const TInstant touchTs, const TDuration ttl);

        const TMatchMap& GetMatches() const;
        const TBackRefMap& GetBackRefs() const;

    private:
        void RebindBackRef(const TId& newMatchedId, const TMatch& oldMatch);
        void AddBackRef(const TId& newMatchedId, const TId& extId);
        void RemoveBackRef(const TId& newMatchedId, const TId& extId);

        TMatchMap Matches;
        TBackRefMap BackRefs;
        const THashSet<TString>& TrackedBackRefTags;
    };
}
