#pragma once

#include "db_state.h"

#include <crypta/cm/services/common/data/id.h>
#include <crypta/cm/services/common/data/id_hash.h>
#include <crypta/lib/native/log/log.h>
#include <crypta/lib/native/stats/stats.h>
#include <crypta/lib/native/yt/dyntables/async_database/kv_database.h>

#include <util/generic/hash_set.h>
#include <util/generic/vector.h>

namespace NCrypta::NCm {
    class TDbStateLoader {
    public:
        using TDatabase = NYtDynTables::TKvDatabase;

        explicit TDbStateLoader(NLog::TLogPtr& log, const THashSet<TString>& trackedBackRefTags);

        TDbState Load(
            TDatabase& database,
            const TVector<TId>& ids,
            bool loadSecondOrderBackRefs,
            bool loadSecondOrderMatches = false);

    private:
        void EnqueueIds(const TVector<TId>& ids);
        void LoadOneStep(TDatabase& database, bool loadSecondOrderBackRefs, bool loadSecondOrderMatches);

        NLog::TLogPtr& Log;

        THashSet<TString> RequestedIds;
        THashSet<TId> SeenIds;

        TVector<TString> LookupBatch;
        THashMap<TId, TMatch> Matches;
        THashMap<TId, TBackReference> BackRefs;
        const THashSet<TString>& TrackedBackRefTags;
    };
}
